#! /usr/bin/nawk -f
BEGIN{
  xu["n,名詞,人,姓氏"]="PROPN"; xf["n,名詞,人,姓氏"]="NameType=Sur";
  xu["n,名詞,人,名"]="PROPN"; xf["n,名詞,人,名"]="NameType=Giv";
  xu["n,名詞,人,その他の人名"]="PROPN"; xf["n,名詞,人,その他の人名"]="NameType=Prs";
  xu["n,名詞,人,複合的人名"]="PROPN"; xf["n,名詞,人,複合的人名"]="NameType=Prs";
  xu["n,名詞,人,関係"]="NOUN";
  xu["n,名詞,人,役割"]="NOUN";
  xu["n,名詞,人,人"]="NOUN";
  xu["n,名詞,主体,書物"]="NOUN";
  xu["n,名詞,主体,国名"]="PROPN"; xf["n,名詞,主体,国名"]="Case=Loc|NameType=Nat";
  xu["n,名詞,主体,集団"]="NOUN";
  xu["n,名詞,主体,機関"]="NOUN";
  xu["n,名詞,主体,動物"]="NOUN";
  xu["n,名詞,天象,天文"]="NOUN";
  xu["n,名詞,天象,気象"]="NOUN";
  xu["n,名詞,天象,怪異"]="NOUN";
  xu["n,名詞,行為,*"]="NOUN";
  xu["n,名詞,不可譲,身体"]="NOUN";
  xu["n,名詞,不可譲,疾病"]="NOUN";
  xu["n,名詞,不可譲,属性"]="NOUN";
  xu["n,名詞,固定物,地名"]="PROPN"; xf["n,名詞,固定物,地名"]="Case=Loc|NameType=Geo";
  xu["n,名詞,固定物,地形"]="NOUN"; xf["n,名詞,固定物,地形"]="Case=Loc";
  xu["n,名詞,固定物,樹木"]="NOUN";
  xu["n,名詞,固定物,建造物"]="NOUN"; xf["n,名詞,固定物,建造物"]="Case=Loc";
  xu["n,名詞,固定物,関係"]="NOUN"; xf["n,名詞,固定物,関係"]="Case=Loc";
  xu["n,名詞,可搬,糧食"]="NOUN";
  xu["n,名詞,可搬,道具"]="NOUN";
  xu["n,名詞,可搬,乗り物"]="NOUN";
  xu["n,名詞,可搬,伝達"]="NOUN";
  xu["n,名詞,可搬,成果物"]="NOUN";
  xu["n,名詞,制度,場"]="NOUN"; xf["n,名詞,制度,場"]="Case=Loc";
  xu["n,名詞,制度,儀礼"]="NOUN";
  xu["n,名詞,外観,人"]="NOUN";
  xu["n,名詞,数量,*"]="NOUN";
  xu["n,名詞,時,*"]="NOUN"; xf["n,名詞,時,*"]="Case=Tem";
  xu["n,名詞,度量衡,*"]="NOUN"; xf["n,名詞,度量衡,*"]="NounType=Clf";
  xu["n,名詞,思考,*"]="NOUN";
  xu["n,名詞,描写,態度"]="NOUN";
  xu["n,名詞,描写,形質"]="NOUN";
  xu["n,代名詞,人称,起格"]="PRON";
  xu["n,代名詞,人称,止格"]="PRON";
  xu["n,代名詞,人称,他"]="PRON";
  xu["n,代名詞,指示,*"]="PRON"; xf["n,代名詞,指示,*"]="PronType=Dem";
  xu["n,代名詞,疑問,*"]="PRON"; xf["n,代名詞,疑問,*"]="PronType=Int";
  xu["n,数詞,数字,*"]="NUM";
  xu["n,数詞,数,*"]="NUM";
  xu["n,数詞,干支,*"]="NUM"; xf["n,数詞,干支,*"]="NumType=Ord";
  xu["v,動詞,存在,量"]="VERB";
  xu["v,動詞,存在,存在"]="VERB";
  xu["v,動詞,変化,生物"]="VERB";
  xu["v,動詞,変化,制度"]="VERB";
  xu["v,動詞,変化,性質"]="VERB";
  xu["v,動詞,描写,態度"]="VERB"; xf["v,動詞,描写,態度"]="Degree=Pos";
  xu["v,動詞,描写,量"]="VERB"; xf["v,動詞,描写,量"]="Degree=Pos";
  xu["v,動詞,描写,形質"]="VERB"; xf["v,動詞,描写,形質"]="Degree=Pos";
  xu["v,動詞,描写,境遇"]="VERB"; xf["v,動詞,描写,境遇"]="Degree=Pos";
  xu["v,動詞,行為,役割"]="VERB";
  xu["v,動詞,行為,分類"]="VERB"; xf["v,動詞,行為,分類"]="Degree=Equ";
  xu["v,動詞,行為,飲食"]="VERB";
  xu["v,動詞,行為,姿勢"]="VERB";
  xu["v,動詞,行為,得失"]="VERB";
  xu["v,動詞,行為,移動"]="VERB";
  xu["v,動詞,行為,設置"]="VERB";
  xu["v,動詞,行為,動作"]="VERB";
  xu["v,動詞,行為,生産"]="VERB";
  xu["v,動詞,行為,儀礼"]="VERB";
  xu["v,動詞,行為,伝達"]="VERB";
  xu["v,動詞,行為,態度"]="VERB";
  xu["v,動詞,行為,交流"]="VERB";
  xu["v,動詞,行為,使役"]="VERB";
  xu["v,前置詞,基盤,*"]="ADP";
  xu["v,前置詞,経由,*"]="ADP";
  xu["v,前置詞,関係,*"]="ADP";
  xu["v,前置詞,源泉,*"]="ADP";
  xu["v,前置詞,処置,*"]="ADP";
  xu["v,副詞,描写,*"]="ADV";
  xu["v,副詞,程度,極度"]="ADV"; xf["v,副詞,程度,極度"]="AdvType=Deg|Degree=Sup";
  xu["v,副詞,程度,軽度"]="ADV"; xf["v,副詞,程度,軽度"]="AdvType=Deg|Degree=Pos";
  xu["v,副詞,程度,やや高度"]="ADV"; xf["v,副詞,程度,やや高度"]="AdvType=Deg|Degree=Cmp";
  xu["v,副詞,範囲,総括"]="ADV";
  xu["v,副詞,範囲,限定"]="ADV";
  xu["v,副詞,範囲,共同"]="ADV";
  xu["v,副詞,時相,完了"]="ADV"; xf["v,副詞,時相,完了"]="AdvType=Tim|Aspect=Perf";
  xu["v,副詞,時相,過去"]="ADV"; xf["v,副詞,時相,過去"]="AdvType=Tim|Tense=Past";
  xu["v,副詞,時相,現在"]="ADV"; xf["v,副詞,時相,現在"]="AdvType=Tim|Tense=Pres";
  xu["v,副詞,時相,将来"]="ADV"; xf["v,副詞,時相,将来"]="AdvType=Tim|Tense=Fut";
  xu["v,副詞,時相,終局"]="ADV"; xf["v,副詞,時相,終局"]="AdvType=Tim";
  xu["v,副詞,時相,緊接"]="ADV"; xf["v,副詞,時相,緊接"]="AdvType=Tim";
  xu["v,副詞,時相,継起"]="ADV"; xf["v,副詞,時相,継起"]="AdvType=Tim";
  xu["v,副詞,時相,恒常"]="ADV"; xf["v,副詞,時相,恒常"]="AdvType=Tim";
  xu["v,副詞,時相,変化"]="ADV"; xf["v,副詞,時相,変化"]="AdvType=Tim";
  xu["v,副詞,頻度,重複"]="ADV";
  xu["v,副詞,頻度,頻繁"]="ADV";
  xu["v,副詞,頻度,偶発"]="ADV";
  xu["v,副詞,否定,無界"]="ADV"; xf["v,副詞,否定,無界"]="Polarity=Neg";
  xu["v,副詞,否定,体言否定"]="ADV"; xf["v,副詞,否定,体言否定"]="Polarity=Neg";
  xu["v,副詞,否定,有界"]="ADV"; xf["v,副詞,否定,有界"]="Polarity=Neg";
  xu["v,副詞,否定,禁止"]="ADV"; xf["v,副詞,否定,禁止"]="Polarity=Neg";
  xu["v,副詞,判断,確定"]="ADV";
  xu["v,副詞,判断,推定"]="ADV";
  xu["v,副詞,判断,逆接"]="ADV";
  xu["v,副詞,疑問,反語"]="ADV";
  xu["v,副詞,疑問,原因"]="ADV"; xf["v,副詞,疑問,原因"]="AdvType=Cau";
  xu["v,副詞,疑問,所在"]="ADV";
  xu["v,助動詞,可能,*"]="AUX"; xf["v,助動詞,可能,*"]="Mood=Pot";
  xu["v,助動詞,必要,*"]="AUX"; xf["v,助動詞,必要,*"]="Mood=Nec";
  xu["v,助動詞,願望,*"]="AUX"; xf["v,助動詞,願望,*"]="Mood=Des";
  xu["v,助動詞,受動,*"]="AUX"; xf["v,助動詞,受動,*"]="Voice=Pass";
  xu["p,助詞,提示,*"]="PART";
  xu["p,助詞,接続,属格"]="SCONJ";
  xu["p,助詞,接続,体言化"]="PART";
  xu["p,助詞,接続,並列"]="CCONJ";
  xu["p,助詞,句末,*"]="PART";
  xu["p,助詞,句頭,*"]="PART";
  xu["p,感嘆詞,*,*"]="INTJ";
  xu["p,接尾辞,*,*"]="PART";
  xu["s,文字,*,*"]="SYM";
  xu["s,記号,一般,*"]="SYM";
  xu["s,記号,句点,*"]="PUNCT";
  xu["s,記号,読点,*"]="PUNCT";
  xu["s,記号,括弧開,*"]="PUNCT";
  xu["s,記号,括弧閉,*"]="PUNCT";
  xu["s,記号,空白,*"]="PUNCT";
}
{
  if($1=="EOS"){
    printf("EOS\n");
    next;
  }
  if(NF==1){
    split($1,a,",");
    form=a[1];
    sep=","a[2]","a[3]","a[4]",";
    i=4;
  }
  else{
    split($2,a,",");
    form=$1;
    sep="\t";
    i=0;
  }
  xpos=a[i+1]","a[i+2]","a[i+3]","a[i+4];
  delim=a[i+5]","a[i+6];
  lemma=a[i+7];
  gloss=a[i+10];
  if(gloss=="*"){
    if(xpos=="n,名詞,人,姓氏")
      gloss="[surname]";
    else if(xpos=="n,名詞,人,名")
      gloss="[given-name]";
    else if(xpos=="n,名詞,主体,国名")
      gloss="[country-name]";
    else if(xpos=="n,名詞,固定物,地名"){
      if(length(form)<8||form!~/(府|縣|郡)$/)
	gloss="[place-name]";
    }
  }
  pos=xu[xpos];
  if(pos=="")
    pos="X";
  feat=xf[xpos];
  if(feat==""){
    feat="*";
    if(xpos~/^n,代名詞,人称,/){
      if(gloss~/^\[[1-3]PRON\]$/)
	feat="Person="substr(gloss,2,1)"|PronType=Prs";

      else if(gloss=="self")
	feat="PronType=Prs|Reflex=Yes";
      else
	feat="PronType=Prs";
    }
    else if(xpos=="v,動詞,存在,存在"){
      if(lemma=="爲")
	feat="VerbType=Cop";
      else if(gloss~/not/)
	feat="Polarity=Neg";
    }
  }
  printf("%s%s%s,%s,%s,%s,%s,%s\n",form,sep,xpos,delim,lemma,pos,feat,gloss);
}
