#!/bin/sh
export LANG=ja_JP.eucJP

egrep -h '^[^---ڣ--]+,' \
  ../../mecab-ipadic-2.7.0-20070801/Noun.csv \
| grep -v '^[]' \
| grep -v '^,' \
| grep -v '^,' \
| grep -v '^ͭ,' \
| grep -v '^ܽ,' \
| grep -v '^,' \
| awk 'BEGIN { FS=","; } \
{ printf("%s,0,0,0,n,%s,%s,%s,%s,*,%s,%s,%s,%s\n", \
         $1, $5, $6, $7, $8, $1, $11, $12, $9); }' \
| iconv -f euc-jp -t utf-8 > Noun.csv

egrep -h '^[^---ڣ--]+,' \
  ../../mecab-ipadic-2.7.0-20070801/Noun.adverbal.csv \
| grep -v '^[]' \
| grep -v '^Τ,' \
| grep -v '^,' \
| awk 'BEGIN { FS=","; } \
{ printf("%s,0,0,0,n,%s,%s,%s,%s,*,%s,%s,%s,%s\n", \
         $1, $5, $6, $7, $8, $1, $11, $12, $9); }' \
| iconv -f euc-jp -t utf-8 > Noun.adverbal.csv

egrep -h '^[^---ڣ--]+,' \
  ../../mecab-ipadic-2.7.0-20070801/Noun.number.csv \
| awk 'BEGIN { FS=","; } \
{ printf("%s,0,0,0,n,,%s,*,*,%s,%s,%s,%s,%s\n", \
         $1, $6, $7, $1, $11, $12, $9); }' \
| iconv -f euc-jp -t utf-8 > Noun.number.csv

egrep -h '^[^---ڣ--],' \
  ../../mecab-ipadic-2.7.0-20070801/Suffix.csv \
| grep -v ',̾,,³,' \
| grep -v ',̾,,ư촴,' \
| grep -v ',̾,,ü,' \
| grep -v '^,' \
| grep -v '^,' \
| grep -v '^,' \
| grep -v '^,' \
| grep -v '^,' \
| grep -v '^,' \
| grep -v '^,' \
| grep -v '^,' \
| awk 'BEGIN { FS=","; } \
{ printf("%s,0,0,0,n,%s,%s,*,*,*,%s,%s,%s,%s\n", \
         $1, $7, $8, $1, $11, $12, $9); }' \
| sed 's/,n,,/,n,̻,/' \
| sed 's/,n,ϰ,/,n,ϰ,/' \
| sed 's/,n,̾,/,n,̾,/' \
| sed 's/,n,ǽ,\*,/,n,,ǽ,/' \
| sed 's/,n,,\*,/,n,,,/' \
| iconv -f euc-jp -t utf-8 > Suffix.csv

grep -h '^\(.\|..\),' ../../mecab-ipadic-2.7.0-20070801/Noun.verbal.csv \
| grep -v '^[---ڣ--]' \
| grep -v '^.[---ڣ--]' \
| grep -v '^,' \
| awk 'BEGIN { FS=","; } \
{ printf("%s,0,0,0,v,ư,Ω,%s,%s,*,%s,%s,%s,ѡݥ\n", \
         $1, $7, $8, $1, $11, $12, $9); }' \
| iconv -f euc-jp -t utf-8 > Verb.s.csv

grep -h 'ʸܷ' ../../mecab-ipadic-2.7.0-20070801/Adj.csv \
| sed 's/\(ʤ\|ʤ\|Ф\|\|\|\),/,/' | grep -v '^,' \
| grep -v '^[---ڣ--]' | grep '^.,' \
| awk 'BEGIN { FS=","; } \
{ printf("%s,0,0,0,v,%s,%s,%s,%s,*,%s,%s,%s,%s\n", \
         $1, $5, $6, $7, $8, $1, $11, $12, $9); }' \
| sed 's/\(\|\),/,/' \
| iconv -f euc-jp -t utf-8 > Adj.csv

grep -h 'ܷ' ../../mecab-ipadic-2.7.0-20070801/Verb.csv \
| sed 's/\(\|\|\|\|\|\|\|\|ʤ\|Ϥ\|Ф\|ޤ\|䤹\|餹\|魯\|\|\|\|\|\|\|\|ʤ\|Ϥ\|Ф\|ޤ\|\|\|\|\|\|\|\|\|Ĥ\|Ť\|̤\|դ\|֤\|\|\|\|\|\|\|\|Ƥ\|Ǥ\|ͤ\|ؤ\|٤\|\|\|\|\|\|\|\|\|\|\|\|\|\|\|\|\),/,/' \
| grep -v '^,' \
| grep -v '^[---ڣ--]' | grep '^.,' \
| awk 'BEGIN { FS=","; } \
{ printf("%s,0,0,0,v,%s,%s,%s,%s,*,%s,%s,%s,%s\n", \
         $1, $5, $6, $7, $8, $1, $11, $12, $9); }' \
| sort | uniq | iconv -f euc-jp -t utf-8 > Verb.i.csv

egrep -h '^[^---ڣ---أ-]+,' \
  ../../mecab-ipadic-2.7.0-20070801/Symbol.csv \
| awk 'BEGIN { FS=","; } \
{ printf("%s,0,0,0,s,%s,%s,%s,%s,*,%s,%s,%s,%s\n", \
         $1, $5, $6, $7, $8, $1, $11, $12, $9); }' \
| iconv -f euc-jp -t utf-8 > Symbol.csv
