(defun mecab-kanbun-make-variants-string (string feature)
  (let ((len (length string))
	fc fcs variants rest-string dest ret)
    (if (= len 0)
	nil
      (setq fc (aref string 0))
      (setq variants (char-feature fc feature))
      (setq ret (mecab-kanbun-make-variants-string
		 (setq rest-string (substring string 1))
		 feature))
      (if (null variants)
	  (if (null ret)
	      nil
	    (setq fcs (char-to-string fc))
	    (dolist (rest ret)
	      (setq ret (concat fcs rest))
	      (unless (member ret dest)
		(setq dest (cons ret dest))))
	    dest)
	(if (null ret)
	    (mapcar
	     (lambda (variant)
	       (concat (char-to-string variant) rest-string))
	     variants)
	  (dolist (rest ret)
	    (dolist (variant variants)
	      (setq ret (concat (char-to-string variant) rest))
	      (unless (member ret dest)
		(setq dest (cons ret dest)))))
	  dest)))))

(defun mecab-kanbun-make-combination (sequence variants)
  (let ((head (car sequence))
	(rest (cdr sequence))
	dest)
    (if (null rest)
	(list head)
      (dolist (sel (mecab-kanbun-make-combination rest variants))
	(dolist (variant variants)
	  (setq dest
		(cons (format "%s%c%s" head variant sel)
		      dest))))
      dest)))

(defun mecab-kanbun-japanese-traditionalize-string (string)
  (mecab-kanbun-make-combination
   (mapcar #'japanese-traditionalize-string
	   (split-string string "$BJ[(B"))
   (char-feature ?$BJ[(B '<-simplified@JP/Jouyou)))

(defun mecab-kanbun-generate-variants (input-file output-file)
  (with-temp-buffer
    (insert-file-contents input-file)
    (goto-char (point-min))
    (let ((output-buf (find-file-noselect output-file))
	  line
	  ps-major ps ps-sub ps-sem ps-direction ct
	  notation notation-canonical
	  notation-ja notation-ja-yomi ja-conj)
      (with-current-buffer output-buf
	(erase-buffer))
      (while (not (eobp))
	(setq line
	      (split-string
	       (buffer-substring (point-at-bol) (point-at-eol))
	       ","))
	(setq notation (car line)
	      ps-major (nth 4 line)
	      ps       (nth 5 line)
	      ps-sub   (nth 6 line)
	      ps-sem   (nth 7 line)
	      ps-direction (nth 8 line)
	      ct (nth 9 line)
	      notation-canonical (nth 10 line)
	      notation-ja (nth 11 line)
	      notation-ja-yomi (nth 12 line)
	      ja-conj  (nth 13 line))
        ;; (setq notation-canonical
        ;;       (japanese-traditionalize-string notation-canonical))
	(with-current-buffer output-buf
	  (dolist (nc (mecab-kanbun-japanese-traditionalize-string
		       notation-canonical))
	    (unless (string= nc notation)
	      (insert
	       (format
		"%s,0,0,0,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s\n"
		nc ps-major ps ps-sub ps-sem ps-direction ct
		nc notation-ja notation-ja-yomi ja-conj)))
	    (insert
	     (format
	      "%s,0,0,0,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s\n"
	      notation ps-major ps ps-sub ps-sem ps-direction ct
	      nc notation-ja notation-ja-yomi ja-conj))
	    (dolist (oc (mecab-kanbun-make-variants-string
			 nc '->original))
	      (unless (string= oc nc)
		(insert
		 (format
		  "%s,0,0,0,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s\n"
		  oc ps-major ps ps-sub ps-sem ps-direction ct
		  nc notation-ja notation-ja-yomi ja-conj))))
	    ))
	(forward-line))
      (with-current-buffer output-buf
	(save-buffer)))))
